#define INCL_WIN
#define INCL_PM
#define INCL_GPI
#define INCL_DOS
#define INCL_DOSPROCESS
// #define INCL_WINSTDFILE   /* OS/2 include for File Dialog */
// #define INCL_WINDIALOGS   /* OS/2 include for Window Dialog */
#include <os2.h>

/* DIVE required header files  */
#define  _MEERROR_H_
#include <mmioos2.h>
#include <dive.h>
#include <fourcc.h>


#include "sysconfig.h"
#include "sysdeps.h"

#include <ctype.h>
#include <signal.h>

#include "config.h"
#include "options.h"
#include "threaddep/penguin.h"
#include "uae.h"
#include "memory.h"
#include "custom.h"
#include "readcpu.h"
#include "newcpu.h"
#include "xwin.h"
#include "keyboard.h"
#include "keybuf.h"
#include "gui.h"
#include "debug.h"
#include "picasso96.h"
#include "disk.h"
#include "gensound.h"
#include "drawing.h"
#include "pm_scancode.h"
#include "sounddep/sound.h"
#include "osdep/os2dive.h"
#include "osdep/uae2rc.h"
#include "osdep/notebook.h"
#include "osdep/filedlg.h"

#include <stdlib.h>

/* Dive variables */
DIVE_CAPS          DiveCaps           = {0};
FOURCC             fccFormats[100]    = {0};
HDIVE              hDive              = NULLHANDLE;
BOOL               bDiveHaveBuffer    = FALSE;
ULONG              ulDiveBufferNumber = 0;
ULONG              ulDiveBufferNumber2 = 0;
HDC                hdcClientHDC = NULLHANDLE;
HPAL               hpalMain;
HPS                hps;
BOOL               VideoOut=FALSE;


/* PM Window variables */
HAB                habmain,hab;
HMQ                hmq;
HWND               hwndUAEFrame, hwndUAEClient ;
QMSG               qmsg;
HPS                hpsMainHPS;
FONTMETRICS        fm;
RECTL              udrcl;
CHAR               pszAmigaClass[]= "AmigaWndClass";
CHAR               pszTitleText[] = PRODUCT;
BOOL               pm_err;
ULONG              ulFramesToTime=8;             /* Interval of frames to get time    */
ULONG              ulNumFrames=0;                /* Frame counter                     */


// IPC variables
HEV                TWaitEvent=0;
TID                tid_emu, tid_pmThread;
PID                pid;

// internal variables
USHORT             screenx,screeny,xborderwidth,yborderwidth,titleheight,width,height;
BYTE               XBuf[WIDTH*HEIGHT];
BYTE               XBufMask[HEIGHT];
BOOL               keystate[256];

// Emu-GUI Variables
HWND               hwnd_DLG_CONFIG;
BOOL               EmuRunning;
HEV                hevEmuRunning;
ULONG              pcEmuRunning;
struct uae_prefs   workprefs;

CHAR               pszContributors[] =  "Bernd Schmidt   - The Grand-Master\n"
                                        "Mathias Ortmann - WinUAE Main Guy\n"
                                        "Brian King      - Picasso96 Support, Integrated GUI for WinUAE, AHI (Working on it)\n"
                                        "Toni Wilen      - AGA, NTSC/PAL modes, chipset switching, track-displays\n"
                                        "Gustavo Goedert/Peter Remmers/Michael Sontheimer/Tomi Hakala/Tim Gunn/Nemo Pohle - DOS Port Stuff\n"
                                        "Samuel Devulder/Olaf Barthel - Amiga Port\n"
                                        "Krister Bergman - XFree86 and OS/2 Port\n"
                                        "A. Blanchard/Ernesto Corvi - MacOS Port\n"
                                        "Christian Bauer - BeOS Port\n"
                                        "Ian Stephenson  - NextStep Port\n"
                                        "Peter Teichmann - Acorn/RiscOS Port\n"
                                        "Stefan Reinauer - ZorroII/III AutoConfig, Serial Support\n"
                                        "Christian Schmitt/Chris Hames - Serial Support\n"
                                        "Herman ten Brugge - 68020/68881 Emulation Code\n"
                                        "Tauno Taipaleenmaki - Various UAE-Control/UAE-Library Support\n"
                                        "Brett Eden/Tim Gunn/Paolo Besser/Nemo Pohle - Various Docs and Web-Sites\n"
                                        "Fulvio Leonardi - Italian translator for WinUAE\n"
                                        "Special thanks to Alexander Kneer and Tobias Abt (The Picasso96 Team)"
                                       ;

/*
void write_log (const char *buf)
{
    fprintf (stderr, buf);
}
*/

void pause_Emu(int state)
{
  if (state) {
    EmuRunning = FALSE;
    stop_sound();
    DosResetEventSem(hevEmuRunning,&pcEmuRunning);
  } else {
    EmuRunning = TRUE;
    start_sound();
    DosPostEventSem(hevEmuRunning);
  }
}

int debuggable(void)
{
    return 0;
}

void handle_events (void)
{
}

int needmousehack (void)
{
    return 1;
}

void LED (int on)
{
}

void setup_brkhandler(void)
{
}

void flush_line(int n)
{
//  bzero(XBufMask,HEIGHT);
//  XBufMask[n] = 0xff;
//  DiveBlitImageLines (hDive, ulDiveBufferNumber, DIVE_BUFFER_SCREEN,XBufMask);
//  XBufMask[n] = 0x00;
}

void flush_block(int a, int b)
{
//  if (VideoOut)
  {
    memset(&XBufMask[a],0xff,b-a+1);
    DiveBlitImageLines (hDive, ulDiveBufferNumber, DIVE_BUFFER_SCREEN,XBufMask);
    memset(&XBufMask[a],0x00,b-a+1);
  }
}

void flush_screen(int a, int b)
{
//  if (EmuRunning)
//    DiveBlitImage (hDive, ulDiveBufferNumber, DIVE_BUFFER_SCREEN );
}

void graphics_leave(void)
{
  dive_unmap();
}
/*
void get_processor_time(void)
{
long i;

  write_log("Measuring clock rate...\n");
  i = read_processor_time ();
   _sleep2 (1000);
  i = read_processor_time () - i;
  printf ("Your machine is running at approx. %d MHz\n", i/1000000);
//  vsynctime =i / 50;
}
*/

// check if dive is present ...
BOOL dive_query(void)
{
   /* Get the screen capabilities, and if the system supports only 16 colors
    *  the program should be terminated.
    */

   DiveCaps.pFormatData    = fccFormats;
   DiveCaps.ulFormatLength = 100;
   DiveCaps.ulStructLen    = sizeof(DIVE_CAPS);

   if ( DiveQueryCaps ( &DiveCaps, DIVE_BUFFER_SCREEN )) {
      printf("Error: DIVE routines cannot function in this system environment.\n");
      return (TRUE);
   }

   if ( DiveCaps.ulDepth < 16 ) {
      printf("Error: Not enough screen colors to run DIVE. Must be at least 16 bit colors.\n");
      return (TRUE);
   }
   return (FALSE);
}


// init dive
BOOL dive_init(void)
{
   if ( DiveOpen ( &hDive, FALSE, 0 ) ) {
      write_log("Error: Unable to open an instance of DIVE.\n");
      return (TRUE);
   }
   return (FALSE);
}


// allocate memory for drawing
BOOL dive_map(void)
{
 ULONG rc;

   ulDiveBufferNumber = 0;
   bDiveHaveBuffer = FALSE;

   // Associate the canvas with a DIVE handle
   if (rc = DiveAllocImageBuffer (hDive, &ulDiveBufferNumber, FOURCC_LUT8, WIDTH, HEIGHT, WIDTH, &XBuf[0]) )
   {
      printf("Error allocating Image Buffer # 0x%x\n",rc);
      return (TRUE);
   }
   bDiveHaveBuffer = TRUE;

   bzero(XBufMask,HEIGHT);
   // Turn on visible region notification.
   WinSetVisibleRegionNotify (hwndUAEClient, TRUE);

   // Send an invalidation message to the client.
   WinPostMsg (hwndUAEFrame, WM_VRNENABLED, 0L, 0L );

   write_log("Image Buffer Allocated\n");
   return (FALSE);
}


void dive_unmap(void)
{
   if (bDiveHaveBuffer)
   {
      DiveFreeImageBuffer (hDive, ulDiveBufferNumber);
      ulDiveBufferNumber = 0;
      bDiveHaveBuffer = FALSE;
   }
}
/*
void write_log (const char *buf)
{
    fprintf (stderr, buf);
}
*/

__inline__  void checkEmuRunning(void)
{
  DosWaitEventSem(hevEmuRunning,SEM_INDEFINITE_WAIT);
}


int graphics_setup(void)
{
 PTIB           ptib;
 PPIB           ppib;


  printf("Trying to determine if system if capable for Dive\n");

  // change process type to a pm app
//  get_processor_time();
  DosGetInfoBlocks(&ptib,&ppib);
  pid = ppib->pib_ulpid;
  tid_emu = ptib->tib_ptib2->tib2_ultid;
  ppib->pib_ultype = PROG_PM;
  habmain = WinInitialize(0) ;

  if (dive_query())
    return 0;
  if (StartSettingsDialog())
    return 0;

  return 1;
}

// currently only hi and true color supported !!!!
static xcolnr xcol8[4096];
static RGB2 colors256[256];
static int ncols256 = 0;


static int get_color (int r, int g, int b, xcolnr *cnp)
{
    if (ncols256 == 256)
        return 0;
    colors256[ncols256].bBlue      = b * 0xe;
    colors256[ncols256].bGreen     = g * 0xe;
    colors256[ncols256].bRed       = r * 0xe;
    colors256[ncols256].fcOptions  = PC_RESERVED;
    *cnp = ncols256;
    ncols256++;
//    printf("%0.3d: R = %ld , G = %ld , B = %ld\n",ncols256,r,g,b);
    return 1;
}


static void colors_init (void)
{
    if (ncols256 == 0)
        alloc_colors256 (get_color);
    memcpy (xcol8, xcolors, sizeof xcol8);
    memcpy (xcolors, xcol8, sizeof xcolors);
}


int graphics_init(void)
{
 ULONG tmpx,n;

  write_log("Trying to Init Graphics System (OS/2 Dive)\n");
  dive_init();
  DosCreateEventSem(NULL,&TWaitEvent,0L,0);

  memset(keystate,0,sizeof(keystate));

  // start the pm msg queue thread
  tid_pmThread = _beginthread((void*)pmThread,NULL, 0x8000,NULL);
  if (tid_pmThread == -1)
    return 0;
  DosWaitEventSem(TWaitEvent,SEM_INDEFINITE_WAIT);
  if (pm_err)
    return 0;

  gfxvidinfo.bufmem             = &XBuf[0];
  gfxvidinfo.linemem            = NULL;
//  gfxvidinfo.emergmem           = NULL;
  gfxvidinfo.rowbytes           = WIDTH;
  gfxvidinfo.pixbytes           = 1;
  gfxvidinfo.width              = WIDTH;
  gfxvidinfo.height             = HEIGHT;
  gfxvidinfo.maxblocklines      = HEIGHT;
  gfxvidinfo.can_double         = 0;

  bzero(XBuf,sizeof(XBuf));
  DosSetPriority(PRTYS_THREAD,PRTYC_IDLETIME,0,0L);
  DosPostEventSem(hevEmuRunning);
  EmuRunning = TRUE;
  VideoOut = TRUE;
  return 1;
}

VOID APIENTRY pmThread( void )
{
 ULONG flCreate;

  memcpy(&workprefs,&currprefs,sizeof(currprefs));
  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue(hab,0);

  // Register a window class, and create a standard window.
  WinRegisterClass ( hab, pszAmigaClass, AmigaWndProc, 0, sizeof(ULONG) );

//  flCreate = FCF_TASKLIST|FCF_TITLEBAR|FCF_BORDER|FCF_MINBUTTON|FCF_SYSMENU|FCF_SHELLPOSITION ;
  flCreate = FCF_TASKLIST|FCF_TITLEBAR|FCF_BORDER|FCF_MINMAX|FCF_SIZEBORDER|FCF_SYSMENU;

  hwndUAEFrame = WinCreateStdWindow ( HWND_DESKTOP,
                                   WS_VISIBLE,
                                   &flCreate,
                                   pszAmigaClass,
                                   pszTitleText,
                                   WS_SYNCPAINT | WS_VISIBLE,
                                   0,
                                   0,
                                   &hwndUAEClient);

  // init some global variables
  screenx      = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN);
  screeny      = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);
  xborderwidth = WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER);
  yborderwidth = WinQuerySysValue(HWND_DESKTOP, SV_CYSIZEBORDER);
  titleheight  = WinQuerySysValue(HWND_DESKTOP, SV_CYTITLEBAR);
//  width        = currprefs.gfx_width;
//  height       =  currprefs.gfx_height;

  width        = WIDTH;
  height       = HEIGHT;

  // start the show ...
  hwnd_DLG_CONFIG = WinLoadDlg(HWND_DESKTOP,hwndUAEFrame,DLG_CONFIG_Proc,NULLHANDLE,DLG_CONFIG,NULL);
  WinSetWindowPos(hwndUAEFrame, NULLHANDLE,
                  (screenx - width - 2*xborderwidth)/2,
                  (screeny - height- 2*yborderwidth - titleheight)/2,
                  width + 2*xborderwidth ,
                  height + 2*yborderwidth + titleheight,
                  SWP_SIZE|SWP_MOVE|SWP_ACTIVATE);


/*
  // Turn on visible region notification.
  WinSetVisibleRegionNotify ( hwndUAEClient, TRUE );

  // Send an invlaidation message to the client.
  WinPostMsg ( hwndUAEFrame, WM_VRNENABLED, 0L, 0L );
*/

// alloc Mem for DIVE
  dive_map();
  pm_err = FALSE;

  DosCreateEventSem(NULL,&hevEmuRunning,0L,0);
  DosPostEventSem(TWaitEvent);
  DosCloseEventSem(TWaitEvent);

  while ( WinGetMsg ( hab, &qmsg, 0, 0, 0 ) )
     WinDispatchMsg ( hab, &qmsg );

// Cleanup
  WinDestroyWindow (hwndUAEFrame);
  WinDestroyMsgQueue (hmq);
  WinTerminate(hab);
  uae_quit();
  DosPostEventSem(hevEmuRunning);
//  DosResumeThread(tid_emu);
  return;
}

int pckey2amigakey(PCHRMSG in)
{
  switch(in->scancode) {
   // Ami key's       ;
   case SC_A:             return AK_A               ;
   case SC_B:             return AK_B               ;
   case SC_C:             return AK_C               ;
   case SC_D:             return AK_D               ;
   case SC_E:             return AK_E               ;
   case SC_F:             return AK_F               ;
   case SC_G:             return AK_G               ;
   case SC_H:             return AK_H               ;
   case SC_I:             return AK_I               ;
   case SC_J:             return AK_J               ;
   case SC_K:             return AK_K               ;
   case SC_L:             return AK_L               ;
   case SC_M:             return AK_M               ;
   case SC_N:             return AK_N               ;
   case SC_O:             return AK_O               ;
   case SC_P:             return AK_P               ;
   case SC_Q:             return AK_Q               ;
   case SC_R:             return AK_R               ;
   case SC_S:             return AK_S               ;
   case SC_T:             return AK_T               ;
   case SC_U:             return AK_U               ;
   case SC_V:             return AK_V               ;
   case SC_W:             return AK_W               ;
   case SC_X:             return AK_X               ;
   case SC_Z:             return AK_Y               ;
   case SC_Y:             return AK_Z               ;

   case SC_0:             return AK_0               ;
   case SC_1:             return AK_1               ;
   case SC_2:             return AK_2               ;
   case SC_3:             return AK_3               ;
   case SC_4:             return AK_4               ;
   case SC_5:             return AK_5               ;
   case SC_6:             return AK_6               ;
   case SC_7:             return AK_7               ;
   case SC_8:             return AK_8               ;
   case SC_9:             return AK_9               ;

   case SC_NP_0:          return AK_NP0             ;
   case SC_NP_1:          return AK_NP1             ;
   case SC_NP_2:          return AK_NP2             ;
   case SC_NP_3:          return AK_NP3             ;
   case SC_NP_4:          return AK_NP4             ;
   case SC_NP_5:          return AK_NP5             ;
   case SC_NP_6:          return AK_NP6             ;
   case SC_NP_7:          return AK_NP7             ;
   case SC_NP_8:          return AK_NP8             ;
   case SC_NP_9:          return AK_NP9             ;

   case SC_NP_DIV:        return AK_NPDIV           ;
   case SC_NP_MUL:        return AK_NPMUL           ;
   case SC_NP_SUB:        return AK_NPSUB           ;
   case SC_NP_ADD:        return AK_NPADD           ;
   case SC_NP_DEL:        return AK_NPDEL           ;
   case SC_HOME:          return AK_NPLPAREN        ;
   case SC_PGUP:          return AK_NPRPAREN        ;

   case SC_F1:            return AK_F1              ;
   case SC_F2:            return AK_F2              ;
   case SC_F3:            return AK_F3              ;
   case SC_F4:            return AK_F4              ;
   case SC_F5:            return AK_F5              ;
   case SC_F6:            return AK_F6              ;
   case SC_F7:            return AK_F7              ;
   case SC_F8:            return AK_F8              ;
   case SC_F9:            return AK_F9              ;
   case SC_F10:           return AK_F10             ;

   case SC_UP:            return AK_UP              ;
   case SC_DOWN:          return AK_DN              ;
   case SC_LEFT:          return AK_LF              ;
   case SC_RIGHT:         return AK_RT              ;

   case SC_SPACE:         return AK_SPC             ;
   case SC_BACKSPACE:     return AK_BS              ;
   case SC_TAB:           return AK_TAB             ;
   case SC_NP_ENTER:      return AK_ENT             ;
   case SC_RETURN:        return AK_RET             ;
   case SC_ESC:           return AK_ESC             ;
   case SC_DEL:           return AK_DEL             ;

   case SC_LSHIFT:        return AK_LSH             ;
   case SC_RSHIFT:        return AK_RSH             ;
   case SC_CAPSLOCK:      return AK_CAPSLOCK        ;
   case SC_LCTRL:         return AK_CTRL            ;
   case SC_RCTRL:         return AK_CTRL            ;
   case SC_LALT:          return AK_LALT            ;
   case SC_RALT:          return AK_RALT            ;
   case SC_END:           return AK_LAMI            ;
   case SC_PGDOWN:        return AK_RAMI            ;
   case SC_INSERT:        return AK_HELP            ;

   // special key's   ;
   case SC_UE:            return AK_LBRACKET        ;
   case SC_PLUS:          return AK_RBRACKET        ;
   case SC_OE:            return AK_SEMICOLON       ;
   case SC_KOMMA:         return AK_COMMA           ;
   case SC_PUNKT:         return AK_PERIOD          ;
   case SC_SPIEGELSTRICH: return AK_SLASH           ;
   case SC_AE:            return AK_QUOTE           ;

   case SC_F11:           return AK_BACKSLASH       ;
   case SC_RAUTE:         return AK_NUMBERSIGN      ;

   case SC_LTGT:          return AK_LTGT            ;
   case 0x29:             return AK_BACKQUOTE       ;
   case SC_FRAGEZEICHEN:  return AK_MINUS           ;
   case SC_APOSTROPH:     return AK_EQUAL           ;

   // dummy key'S     ;
   case SC_SCROLE:        return AK_inhibit         ;
   case SC_F12:           return AK_menu            ;
   case SC_PAUSE:         return AK_pause           ;

   default:               return -1;
  }
  return -1;
}

void my_keyboard_func(PCHRMSG in)
{
 static int ak;

  if (in->fs & KC_SCANCODE) {
    ak = pckey2amigakey(in);
    if (in->fs & KC_KEYUP) {
      switch (ak) {                     // KC_KeyUP
       case -1:
         break;
       case AK_pause:
         if (EmuRunning)   pause_Emu(TRUE);
         else              pause_Emu(FALSE);
         break;
       case AK_inhibit:
         toggle_inhibit_frame (IHF_SCROLLLOCK);
         break;
       case AK_menu:
         if (EmuRunning)   DisplayGuiWindow(TRUE);
         else              DisplayGuiWindow(FALSE);
         break;
       default:
        if (!EmuRunning) return;
        record_key((ak << 1) | 1);
        keystate[ak] = FALSE;
      }
    } else  {
      switch (ak) {                     // KC_KeyDown
       case -1:
       case AK_inhibit:
       case AK_menu:
       case AK_pause:
         break;
       default:
         if (!EmuRunning) return;
         if (keystate[ak]) break;
         record_key(ak << 1 );
         keystate[ak] = TRUE;
      }
    }
  }
  if (keystate[AK_LAMI] && keystate[AK_RAMI] && keystate[AK_CTRL])
    uae_reset();
}


MRESULT EXPENTRY AmigaWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 POINTL         pointl;                /* Point to offset from Desktop         */
 SWP            swp;                   /* Window position                      */
 HRGN           hrgn;                  /* Region handle                        */
 HPS            hps;                   /* Presentation Space handle            */
 RECTL          rcls[50];              /* Rectangle coordinates                */
 RGNRECT        rgnCtl;                /* Processing control structure         */
 SETUP_BLITTER  SetupBlitter;          /* structure for DiveSetupBlitter       */
 SIZEL          sizl;

  switch (msg)
  {
   case WM_CREATE:
    colors_init();
    sizl.cx = sizl.cy = 0;
    hdcClientHDC = WinOpenWindowDC (hwnd);
    hpsMainHPS = GpiCreatePS (hab, hdcClientHDC, &sizl,
                              PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC);
    hpalMain = GpiCreatePalette (hab,
                                 LCOL_PURECOLOR,
                                 LCOLF_CONSECRGB,
                                 ncols256,
                                 (PULONG) colors256);
    GpiSelectPalette (hpsMainHPS, hpalMain);
    WinRealizePalette (hwnd, hpsMainHPS, &ncols256);
    DiveSetSourcePalette(hDive,0,ncols256,(PBYTE)colors256);
    DiveSetDestinationPalette(hDive,0,ncols256,0);
    break;

   case WM_CHAR:
     my_keyboard_func(&mp1);
     break;

   case WM_BUTTON1DOWN:
     buttonstate[0] = 1;
     return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
     break;

   case WM_BUTTON1UP:
     buttonstate[0] = 0;
     break;

   case WM_BUTTON2DOWN:
     buttonstate[2] = 1;
     return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
     break;

   case WM_BUTTON2UP:
     buttonstate[2] = 0;
     break;

   case WM_MOUSEMOVE:
     if (!EmuRunning)
       return WinDefWindowProc( hwnd , msg, mp1, mp2);
     lastmx = 2*WIDTH*SHORT1FROMMP(mp1)/width;
     lastmy = 2*HEIGHT*2*(height-SHORT2FROMMP(mp1))/height;
     WinSetPointer( HWND_DESKTOP, 0 );
     break;

   case WM_PAINT:
//    VideoOut = FALSE;
    hps = WinBeginPaint (hwndUAEClient, NULLHANDLE, NULL) ;
    WinQueryWindowRect(hwndUAEClient,&rcls[0]);
    WinFillRect(hps,&rcls[0],CLR_BLACK);
//    DiveBlitImage (hDive, ulDiveBufferNumber, DIVE_BUFFER_SCREEN );
    WinEndPaint (hps) ;

//    VideoOut = TRUE;
    break;

   case WM_SIZE:
//    WinPostMsg (hwndUAEClient, WM_PAINT, 0L, 0L );
    break;

   case WM_ACTIVATE:
//    WinPostMsg (hwndUAEClient, WM_PAINT, 0L, 0L );
    break;

   case WM_REALIZEPALETTE:
    // This tells DIVE that the physical palette may have changed.
    DiveSetDestinationPalette (hDive, 0, ncols256, 0 );
    break;

   case WM_VRNDISABLED:
    DiveSetupBlitter ( hDive, 0 );
    break;

   case WM_VRNENABLED:
    hps = WinGetPS ( hwnd );
    if ( !hps )
       break;
    hrgn = GpiCreateRegion ( hps, 0L, NULL );
    if ( hrgn ) {
//       VideoOut = FALSE;
       /* NOTE: If mp1 is zero, then this was just a move message.
       ** Illustrate the visible region on a WM_VRNENABLE.
       */
//       WinQueryWindowRect(hwndUAEClient,&rcls[0]);
//       WinFillRect(hps,&rcls[0],CLR_BLACK);
       WinQueryVisibleRegion ( hwnd, hrgn );
       rgnCtl.ircStart     = 0;
       rgnCtl.crc          = 50;
       rgnCtl.ulDirection  = 1;

       /* Get the all ORed rectangles
       */
       if ( GpiQueryRegionRects ( hps, hrgn, NULL, &rgnCtl, rcls) ) {
          /* Now find the window position and size, relative to parent.
          */
          WinQueryWindowPos ( hwndUAEClient, &swp );

          /* Convert the point to offset from desktop lower left.
          */
          width = swp.cx;
          height = swp.cy;
          pointl.x = swp.x;
          pointl.y = swp.y;
          WinMapWindowPoints ( hwndUAEFrame, HWND_DESKTOP, &pointl, 1 );

          /* Tell DIVE about the new settings.
          */
          SetupBlitter.ulStructLen = sizeof ( SETUP_BLITTER );
          SetupBlitter.fccSrcColorFormat = FOURCC_LUT8;
          SetupBlitter.ulSrcWidth = WIDTH;
          SetupBlitter.ulSrcHeight = HEIGHT;
          SetupBlitter.ulSrcPosX = 0;
          SetupBlitter.ulSrcPosY = 0;
          SetupBlitter.fInvert = 0;
          SetupBlitter.ulDitherType = 0;

          SetupBlitter.fccDstColorFormat = FOURCC_SCRN;
          if (swp.cx<WIDTH)
            SetupBlitter.ulDstWidth = swp.cx;
          else
          SetupBlitter.ulDstWidth  = WIDTH;

          if (swp.cy<HEIGHT)
            SetupBlitter.ulDstHeight = swp.cy;
          else
            SetupBlitter.ulDstHeight = HEIGHT;

          if (swp.cx<WIDTH)
            SetupBlitter.lDstPosX = 0;
          else
            SetupBlitter.lDstPosX = (swp.cx - WIDTH)/2;

          if (swp.cy<HEIGHT)
            SetupBlitter.lDstPosY = 0;
          else
            SetupBlitter.lDstPosY = (swp.cy - HEIGHT)/2;

          SetupBlitter.lScreenPosX = pointl.x;
          SetupBlitter.lScreenPosY = pointl.y;
          SetupBlitter.ulNumDstRects = rgnCtl.crcReturned;
          SetupBlitter.pVisDstRects = rcls;
          DiveSetupBlitter ( hDive, &SetupBlitter );
          ulFramesToTime=4;
          ulNumFrames=1;
       }
       else
          DiveSetupBlitter ( hDive, 0 );

       DiveBlitImage (hDive, ulDiveBufferNumber, DIVE_BUFFER_SCREEN );
       GpiDestroyRegion( hps, hrgn );
//       VideoOut = TRUE;
       }
    WinReleasePS( hps );
    break;

   case WM_CLOSE:
//    DosSuspendThread(tid_emu);
    DosResetEventSem(hevEmuRunning,&pcEmuRunning);
    WinPostMsg( hwnd, WM_QUIT, 0, 0 );
    break;

   default:
    return WinDefWindowProc ( hwnd, msg, mp1, mp2 );
  }
  return (FALSE);
}


int lockscr (void)
{
    return 1;
}

void unlockscr (void)
{
}

int check_prefs_changed_gfx (void)
{
    return 0;
}


void target_save_options (FILE *f, struct uae_prefs *p)
{
//    fprintf (f, "svga.no_linear=%s\n", p->svga_no_linear ? "true" : "false");
}

int target_parse_option (struct uae_prefs *p, char *option, char *value)
{
//    return (cfgfile_yesno (option, value, "no_linear", &p->svga_no_linear));
}


MRESULT EXPENTRY DLG_CONTRIB_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch (msg) {
   case WM_INITDLG:
    {
     LONG start;

      WinSendMsg( WinWindowFromID(hwnd,MLE_CONTRIB),
                  MLM_SETIMPORTEXPORT,
                  MPFROMP(pszContributors),
                  MPFROMLONG(sizeof(pszContributors))
                );
      start = 0;
      WinSendMsg( WinWindowFromID(hwnd,MLE_CONTRIB),
                  MLM_IMPORT,
                  MPFROMP(&start),
                  MPFROMLONG(sizeof(pszContributors))
                );

    }
    break;
   default:
    return WinDefDlgProc(hwnd,msg,mp1,mp2);
  }
  return FALSE;
}

MRESULT EXPENTRY DLG_SETTING_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 HWND hwndConfigNBK;
 SWCNTRL swctrl;

  switch (msg) {
   case WM_INITDLG:
    {

      // Add the dialog to the switch list
      swctrl.hwnd = hwnd;
      swctrl.hwndIcon = NULLHANDLE;
      swctrl.hprog = NULLHANDLE;// Use the value attributed by the system when the program was loaded
      swctrl.idProcess = pid;
      swctrl.idSession = 0;// Use the current process ID
      swctrl.uchVisibility = SWL_VISIBLE;
      swctrl.fbJump = SWL_JUMPABLE;
      strcpy( swctrl.szSwtitle, "UAE/2 Settings" );
      swctrl.bProgType = PROG_PM;

      WinAddSwitchEntry( &swctrl );

      // Add the NoteBook Pages
      hwndConfigNBK = WinWindowFromID( hwnd, NBKC_CONFIG );
      NBK_AddMajor(hwndConfigNBK,NBKP_MISC,"Misc",NBKP_MISC_Proc,NULL);
//      NBK_AddMajor(hwndConfigNBK,NBKP_CPU,"CPU",NBKP_CPU_Proc,NULL);
      NBK_AddMajor(hwndConfigNBK,NBKP_SOUND,"Sound",NBKP_SOUND_Proc,NULL);
      NBK_AddMajor(hwndConfigNBK,NBKP_FLOPPYDISK,"Disk I/O",NBKP_FLOPPYDISK_Proc,"Floppy Disk");
//      NBK_AddMinor(hwndConfigNBK,NBKP_HARDDISK,NULL,NBKP_HARDDISK_Proc,"Hard Disk");
      NBK_AddMajor(hwndConfigNBK,NBKP_ABOUT,"About",NBKP_ABOUT_Proc,NULL);
      WinSetFocus( HWND_DESKTOP, WinQueryWindow( hwnd, QW_PARENT ) );
    }
    break;
   case WM_CLOSE:
     return WinSendMsg(hwnd,WM_QUIT,NULL,NULL);
     break;
   case WM_COMMAND:
    switch(SHORT1FROMMP(mp1)) {
     case DID_OK: {
       NBK_SendMessage(WinWindowFromID( hwnd_DLG_CONFIG, NBKC_CONFIG ),0,WM_GETVAL,NULL,NULL);
       memcpy(&currprefs,&workprefs,sizeof(currprefs));
       return WinDismissDlg(hwnd,DID_OK);
       break;
     }
     case DID_CANCEL:
      return WinDismissDlg(hwnd,DID_CANCEL);
      break;
    }
    break;
   default:
    return WinDefDlgProc(hwnd,msg,mp1,mp2);
    break;
  }
  return (FALSE);
}


MRESULT EXPENTRY DLG_CONFIG_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
 HWND hwndConfigNBK;

  switch (msg) {
   case WM_INITDLG:
    {
      // Add the NoteBook Pages
      hwndConfigNBK = WinWindowFromID( hwnd, NBKC_CONFIG );
      NBK_AddMajor(hwndConfigNBK,NBKP_FLOPPYDISK,"Disk I/O",NBKP_FLOPPYDISK_Proc,"Floppy Disk");
//      NBK_AddMinor(hwndConfigNBK,NBKP_HARDDISK,NULL,NBKP_HARDDISK_Proc,"Hard Disk");
      NBK_AddMajor(hwndConfigNBK,NBKP_ABOUT,"About",NBKP_ABOUT_Proc,NULL);
//      WinSetFocus( HWND_DESKTOP, WinQueryWindow( hwnd, QW_PARENT ) );
    }
    break;
   case WM_COMMAND:
    switch(SHORT1FROMMP(mp1)) {
     case DID_OK: {
       setCurrPrefs();
       DisplayGuiWindow(FALSE);
      }
      break;
     case DID_CANCEL: {
       memcpy(&workprefs,&currprefs,sizeof(workprefs));
       NBK_SendMessage(WinWindowFromID( hwnd_DLG_CONFIG, NBKC_CONFIG ),0,WM_SETVAL,NULL,NULL);
       DisplayGuiWindow(FALSE);
      }
      break;
     }
     break;
   default:
    return WinDefDlgProc(hwnd,msg,mp1,mp2);
    break;
  }
  return (FALSE);
}

MRESULT EXPENTRY NBKP_ABOUT_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch (msg) {
   case WM_INITDLG:
    break;
   case WM_COMMAND:
    switch(SHORT1FROMMP(mp1)) {
     case PB_CONTRIBUTORS:
      WinDlgBox(HWND_DESKTOP,hwnd,DLG_CONTRIB_Proc,NULLHANDLE,DLG_CONTRIB,NULL);
      break;
     default:
      break;
    }
    break;
   default:
    return WinDefDlgProc(hwnd,msg,mp1,mp2);
  }
  return FALSE;
}

void setval_NBKP_FLOPPYDISK(HWND hwnd)
{
  WinSetDlgItemText(hwnd,EF_DF0,workprefs.df[0]);
  WinSetDlgItemText(hwnd,EF_DF1,workprefs.df[1]);
  WinSetDlgItemText(hwnd,EF_DF2,workprefs.df[2]);
  WinSetDlgItemText(hwnd,EF_DF3,workprefs.df[3]);
}

MRESULT EXPENTRY NBKP_FLOPPYDISK_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch (msg) {
   case WM_INITDLG:
   case WM_SETVAL:
    setval_NBKP_FLOPPYDISK(hwnd);
    break;
   case WM_COMMAND:
    switch(SHORT1FROMMP(mp1)) {
     case PB_INSERT_DF0:
       DiskSelection(0,0);
       WinSetDlgItemText(hwnd,EF_DF0,workprefs.df[0]);
       break;
     case PB_INSERT_DF1:
       DiskSelection(0,1);
       WinSetDlgItemText(hwnd,EF_DF1,workprefs.df[1]);
       break;
     case PB_INSERT_DF2:
       DiskSelection(0,2);
       WinSetDlgItemText(hwnd,EF_DF2,workprefs.df[2]);
       break;
     case PB_INSERT_DF3:
       DiskSelection(0,3);
       WinSetDlgItemText(hwnd,EF_DF3,workprefs.df[3]);
       break;
     case PB_EJECT_DF0:
       workprefs.df[0][0] = '\0';
       WinSetDlgItemText(hwnd,EF_DF0,"");
       break;
     case PB_EJECT_DF1:
       workprefs.df[1][0] = '\0';
       WinSetDlgItemText(hwnd,EF_DF1,"");
       break;
     case PB_EJECT_DF2:
       workprefs.df[2][0] = '\0';
       WinSetDlgItemText(hwnd,EF_DF2,"");
       break;
     case PB_EJECT_DF3:
       workprefs.df[3][0] = '\0';
       WinSetDlgItemText(hwnd,EF_DF3,"");
       break;
     default:
      break;
    }
    break;
   default:
    return WinDefDlgProc(hwnd,msg,mp1,mp2);
  }
  return FALSE;
}

MRESULT EXPENTRY NBKP_HARDDISK_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

void setval_NBKP_SOUND(HWND hwnd)
{
  if (workprefs.produce_sound == 3)
    WinSetDlgBtn(hwnd,RB_SOUND_EMU3,TRUE);
  else if (workprefs.produce_sound == 2)
    WinSetDlgBtn(hwnd,RB_SOUND_EMU2,TRUE);
  else if (workprefs.produce_sound == 1)
    WinSetDlgBtn(hwnd,RB_SOUND_EMU1,TRUE);
  else
    WinSetDlgBtn(hwnd,RB_SOUND_EMU0,TRUE);

  if (workprefs.stereo)
    WinSetDlgBtn(hwnd,CB_SOUND_STEREO,TRUE);
  else
    WinSetDlgBtn(hwnd,CB_SOUND_STEREO,FALSE);

  if (workprefs.sound_bits == 8)
    WinSetDlgBtn(hwnd,RB_SOUND_8BIT,TRUE);
  else
    WinSetDlgBtn(hwnd,RB_SOUND_16BIT,TRUE);

  if (workprefs.sound_freq == 48000 )
    WinSetDlgBtn(hwnd,RB_SOUND_48000,TRUE);
  else if (workprefs.sound_freq == 44100 )
    WinSetDlgBtn(hwnd,RB_SOUND_44100,TRUE);
  else if (workprefs.sound_freq == 22050 )
    WinSetDlgBtn(hwnd,RB_SOUND_22050,TRUE);
  else
    WinSetDlgBtn(hwnd,RB_SOUND_11025,TRUE);
}
/*
void getval_NBKP_SOUND(HWND hwnd)
{
 ULONG rc;
  if (WinGetDlgBtn(hwnd,RB_SOUND_EMU3))
    workprefs.produce_sound = 3;
  else if (WinGetDlgBtn(hwnd,RB_SOUND_EMU2))
    workprefs.produce_sound = 2;
  else if (WinGetDlgBtn(hwnd,RB_SOUND_EMU1))
    workprefs.produce_sound = 1;
  else
    workprefs.produce_sound = 0;

  if (WinGetDlgBtn(hwnd,CB_SOUND_STEREO))
    workprefs.stereo = 1;
  else
    workprefs.stereo = 0;

  if (WinGetDlgBtn(hwnd,RB_SOUND_8BIT))
    workprefs.sound_bits = 8;
  else
    workprefs.sound_bits = 16;

  if (WinGetDlgBtn(hwnd,RB_SOUND_48000))
    workprefs.sound_freq = 48000;
  else if (WinGetDlgBtn(hwnd,RB_SOUND_44100))
    workprefs.sound_freq = 44100;
  else if (WinGetDlgBtn(hwnd,RB_SOUND_22050))
    workprefs.sound_freq = 22050;
  else
    workprefs.sound_freq = 11025;
}
*/

MRESULT EXPENTRY NBKP_SOUND_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch (msg) {
   case WM_INITDLG:
   case WM_SETVAL:
    setval_NBKP_SOUND(hwnd);
    break;
   case WM_GETVAL:
    break;
   case WM_CONTROL:
    if (SHORT2FROMMP(mp1) == BN_CLICKED)
     switch(SHORT1FROMMP(mp1)) {
      case RB_SOUND_EMU0:
        workprefs.produce_sound = 0;
        break;
      case RB_SOUND_EMU1:
        workprefs.produce_sound = 1;
        break;
      case RB_SOUND_EMU2:
        workprefs.produce_sound = 2;
        break;
      case RB_SOUND_EMU3:
        workprefs.produce_sound = 3;
        break;
      case CB_SOUND_STEREO:
        if (workprefs.stereo)
          workprefs.stereo =0;
        else
          workprefs.stereo =1;
        break;
      case RB_SOUND_8BIT:
        workprefs.sound_bits = 8;
        break;
      case RB_SOUND_16BIT:
        workprefs.sound_bits = 16;
        break;
      case RB_SOUND_11025:
        workprefs.sound_freq = 11025;
        break;
      case RB_SOUND_22050:
        workprefs.sound_freq = 22050;
        break;
      case RB_SOUND_44100:
        workprefs.sound_freq = 44100;
        break;
      case RB_SOUND_48000:
        workprefs.sound_freq = 48000;
        break;
     };
     break;
   default:
    return WinDefDlgProc(hwnd,msg,mp1,mp2);
  }
  return FALSE;
}

MRESULT EXPENTRY NBKP_CPU_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  return WinDefDlgProc(hwnd,msg,mp1,mp2);
}

void setval_NBKP_MISC(HWND hwnd)
{
  WinSetDlgItemText(hwnd,EF_ROM,workprefs.romfile);
}


MRESULT EXPENTRY NBKP_MISC_Proc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  switch (msg) {
   case WM_INITDLG:
   case WM_SETVAL:
    setval_NBKP_MISC(hwnd);
    break;
   case WM_COMMAND:
    switch(SHORT1FROMMP(mp1)) {
     case PB_INSERT_ROM:
       DiskSelection(6,-1);
       WinSetDlgItemText(hwnd,EF_ROM,workprefs.romfile);
       break;
     default:
      break;
    }
    break;
   default:
    return WinDefDlgProc(hwnd,msg,mp1,mp2);
  }
  return FALSE;
}

/*
   flag - usage

      0 - load   .adf #nr
      1 - create .adf
      2 - load   .hdf
      3 - save   .hdf
      4 - load   .uae config file
      5 - save   .uae config file
      6 - load   .rom file

*/

void DiskSelection(int flag, int nr)
{
 FILEDLG  fdlg;

  memset(&fdlg,0,sizeof(FILEDLG));
  fdlg.cbSize = sizeof(FILEDLG);                  /*  Structure size. */

  switch(flag)
  {
    case 0:
      fdlg.pszOKButton = "Open";
      fdlg.fl = FDS_CENTER|FDS_OPEN_DIALOG;           /*  FDS_* flags. */
      fdlg.pszIType = UAE_ADF;
      fdlg.pszTitle = "Open Disk File";               /*  Dialog title string. */

      myFileDlg(HWND_DESKTOP,hwnd_DLG_CONFIG,&fdlg);
      if (fdlg.lReturn == DID_OK)
        strcpy(workprefs.df[nr],fdlg.szFullFile);
      break;
    case 1:
      break;
    case 2:
      break;
    case 3:
      break;
    case 4:
      break;
    case 5:
      break;
    case 6:
      fdlg.pszOKButton = "Set";
      fdlg.fl = FDS_CENTER|FDS_OPEN_DIALOG;
      fdlg.pszIType = UAE_ROM;
      fdlg.pszTitle = "Choose a Kickstart-Rom File";

      myFileDlg(HWND_DESKTOP,hwnd_DLG_CONFIG,&fdlg);
      if (fdlg.lReturn == DID_OK)
        strcpy(workprefs.romfile,fdlg.szFullFile);
      break;
    default:
  }
}

void DisplayGuiWindow(int state)
{
  if (state)  {
    write_log("Menu wurde aufgerufen !\n");
    pause_Emu(TRUE);
    WinShowWindow(hwnd_DLG_CONFIG,TRUE);
    WinSetFocus(HWND_DESKTOP,hwnd_DLG_CONFIG);
  } else {
    write_log("Menu wird beendet !\n");
    WinShowWindow(hwnd_DLG_CONFIG,FALSE);
    WinSetFocus( HWND_DESKTOP, hwndUAEClient );
    pause_Emu(FALSE);
  }
}

int StartSettingsDialog(void)
{
  HMQ msgq;
  ULONG rc;

  memcpy(&workprefs,&currprefs,sizeof(workprefs));
  msgq = WinCreateMsgQueue(habmain,0);

  rc = WinDlgBox(HWND_DESKTOP,HWND_DESKTOP,DLG_SETTING_Proc,NULLHANDLE,DLG_CONFIG,NULL);

  WinDestroyMsgQueue (msgq);
  if (rc != DID_OK)
    return 1;
  else
    return 0;
}

void setCurrPrefs(void)
{
  if (strcmp(workprefs.df[0],currprefs.df[0]))
    disk_insert(0,workprefs.df[0]);

  if (strcmp(workprefs.df[1],currprefs.df[1]))
    disk_insert(1,workprefs.df[1]);

  if (strcmp(workprefs.df[2],currprefs.df[2]))
    disk_insert(2,workprefs.df[2]);

  if (strcmp(workprefs.df[3],currprefs.df[3]))
    disk_insert(3,workprefs.df[3]);

//  memcpy(&currprefs,&workprefs,sizeof(currprefs));
}

